/*
 * Decompiled with CFR 0.152.
 */
package de.unhappycodings.quarry.common.network;

import de.unhappycodings.quarry.common.network.base.IPacket;
import de.unhappycodings.quarry.common.network.toclient.QuarryClientBooleanPacket;
import de.unhappycodings.quarry.common.network.toclient.QuarryClientIntPacket;
import de.unhappycodings.quarry.common.network.toclient.QuarryClientModePacket;
import de.unhappycodings.quarry.common.network.toserver.AreaCardItemPacket;
import de.unhappycodings.quarry.common.network.toserver.QuarryBooleanPacket;
import de.unhappycodings.quarry.common.network.toserver.QuarryChangedPacket;
import de.unhappycodings.quarry.common.network.toserver.QuarryIntPacket;
import de.unhappycodings.quarry.common.network.toserver.QuarryModePacket;
import de.unhappycodings.quarry.common.network.toserver.QuarryPowerPacket;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = ModLoadingContext.get().getActiveContainer().getModInfo().getVersion().toString();
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("quarry", "main_channel"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
    private static int index = 0;

    public static void init() {
        PacketHandler.registerClientToServer(QuarryIntPacket.class, QuarryIntPacket::decode);
        PacketHandler.registerClientToServer(QuarryPowerPacket.class, QuarryPowerPacket::decode);
        PacketHandler.registerClientToServer(QuarryModePacket.class, QuarryModePacket::decode);
        PacketHandler.registerClientToServer(QuarryChangedPacket.class, QuarryChangedPacket::decode);
        PacketHandler.registerClientToServer(QuarryBooleanPacket.class, QuarryBooleanPacket::decode);
        PacketHandler.registerClientToServer(AreaCardItemPacket.class, AreaCardItemPacket::decode);
        PacketHandler.registerServerToClient(QuarryClientBooleanPacket.class, QuarryClientBooleanPacket::decode);
        PacketHandler.registerServerToClient(QuarryClientIntPacket.class, QuarryClientIntPacket::decode);
        PacketHandler.registerServerToClient(QuarryClientModePacket.class, QuarryClientModePacket::decode);
    }

    public static <MSG extends IPacket> void registerServerToClient(Class<MSG> packet, Function<FriendlyByteBuf, MSG> decode) {
        CHANNEL.registerMessage(index++, packet, IPacket::encode, decode, IPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static <MSG extends IPacket> void registerClientToServer(Class<MSG> packet, Function<FriendlyByteBuf, MSG> decode) {
        CHANNEL.registerMessage(index++, packet, IPacket::encode, decode, IPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public static void sendToClient(Object packet, ServerPlayer player) {
        CHANNEL.sendTo(packet, player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToServer(Object packet) {
        CHANNEL.sendToServer(packet);
    }

    public static void sendTo(Object packet, ServerPlayer player) {
        if (!(player instanceof FakePlayer)) {
            CHANNEL.sendTo(packet, player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

